<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, X-API-KEY");

include_once "config/Database.php";
include_once "models/Movie.php";
include_once "models/Utilis.php";
include_once "models/Apikey.php";

if($_SERVER["REQUEST_METHOD"] != "POST"){
    $response = array(
        "success" => false,
        "message" => "Unauthorized request method"
    );

    echo json_encode($response);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$auth = new Apikey($db);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$apikey = $headers['x-api-key'] ?? '';

if(!$apikey || !$auth->validateApikey($apikey)){
    $response = array(
        "success" => false,
        "message" => "Unauthorized: Invalid api key or empty",
    );
    echo json_encode($response);
    exit;
}

$movie = new Movie($db);

$contentType = $_SERVER["CONTENT_TYPE"] ?? "";
if(strpos($contentType, "application/json") !== false){
    $data = json_decode(file_get_contents("php://input"));
    
    $_POST = $data ?? [];
} 

$title = $_POST["title"] ?? "";
$category =  $_POST["category"] ?? "";
$description = $_POST["description"] ?? "";
$date = $_POST["date"] ?? "";
$image = $_FILES["image"] ?? "";

if(empty($image)){
    $response = array(
        "success" => false,
        "message" => "Please upload image",
    );
    echo json_encode($response);
    exit;
}

$check_image = new Utils();
$image_info = $check_image->getFileInfo($image);

$image_format = $check_image->checkFileFormat($image_info["extension"]);
$format_result = $image_format;

if(!$format_result["success"]){
    echo json_encode($format_result);
    exit;
}

$image_size = $check_image->checksFileSize($image_info["size"]);
$size_result = $image_size;

if(!$size_result["success"]){
    echo json_encode($size_result);
    exit;
}

$image_upload = $check_image->uploadFileToFolder($image_info["location"], $title, $image_info["extension"]);
$upload_result = $image_upload;

if(!$image_upload["success"]){
    echo json_encode($upload_result);
    exit;
}

if(empty($title) || empty($category) || empty($description) || empty($date)){
    $response = array(
        "success" => false,
        "message" => "All fileds are required"
    );

    echo json_encode($response);
    exit;
}

$movie->title = $title;
$movie->category = $category;
$movie->image = $upload_result["image_name"];
$movie->description = $description;
$movie->date = $date;

$result = $movie->createMovies();

if($result["success"]){

    echo json_encode($result);
    exit;
}

echo json_encode($result);

?>





