<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: GET");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, X-API-KEY");

include_once "config/Database.php";
include_once "models/Category.php";
include_once "models/Apikey.php";

$database = new Database();
$db = $database->getConnection();

$auth = new Apikey($db);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$apikey = $headers['x-api-key'] ?? '';

if(!$apikey || !$auth->validateApikey($apikey)){
    $response = array(
        "success" => false,
        "message" => "Unauthorized: Invalid api key or empty",
    );
    echo json_encode($response);
    exit;
}

$category = new Category($db);
$result = $category->getCategory();

if(!$result["success"]){
    echo json_encode($result);
    exit;
}

echo json_encode($result);







?>