<?php

class Episode{
    public $conn;
    public $table = "episodes";
    public $user_table = "users";

    public $id;
    public $tilte;
    public $link;
    public $movieid;
    public $moviename;
    public $date;

    public function __construct($bd){
        $this->conn = $bd;
    }

    public function createEpisodes(){
        $query = "INSERT INTO " . $this->table . " (title, link, movieid, moviename, date) 
        VALUES( :title, :link, :movieid, :moviename, :date)";

        $insert = $this->conn->prepare($query);

        $this->title = htmlspecialchars(strip_tags($this->title));
        $this->link = htmlspecialchars(strip_tags($this->link));
        $this->movieid = htmlspecialchars(strip_tags($this->movieid));
        $this->moviename = htmlspecialchars(strip_tags($this->moviename));
        $this->date = htmlspecialchars(strip_tags($this->date));

        $insert->bindParam(":title", $this->title);
        $insert->bindParam(":link", $this->link);
        $insert->bindParam(":movieid", $this->movieid);
        $insert->bindParam(":moviename", $this->moviename);
        $insert->bindParam(":date", $this->date);

        if($insert->execute()){
            return true;
        }

        return false;
    }

    public function getEpisode($movie_id, $phone){
        //check request user number if is paid
        $phone_query = "SELECT id, device_id, phone, status, day, date FROM " . $this->user_table . 
        " WHERE phone = :phone LIMIT 1";
        $fetch = $this->conn->prepare($phone_query);
        $phone = htmlspecialchars(strip_tags($phone));
        $fetch->bindParam(":phone", $phone);
        $fetch->execute();

        $numRow = $fetch->rowCount();

        if(!$numRow > 0){
            return array(
                "success" => false,
                "message" => "Unregistered phone number",
            );
        }


        $query = "SELECT id, title, link, movieid, moviename, date FROM " . $this->table . 
        " WHERE movieid = :id ORDER BY id ASC";

        $episode = $this->conn->prepare($query);
        $episode->bindParam(":id", $movie_id, PDO::PARAM_INT);

        $episode->execute();

        $allEpisodes = $episode->fetchAll(PDO::FETCH_ASSOC);

        $posts = [];
        foreach($allEpisodes as $allEpisode){
            $posts [] = $allEpisode;
        }

        if(count($posts) > 0){

            $row = $fetch->fetch(PDO::FETCH_ASSOC);
            if($row["status"] == "unpaid"){
                foreach($posts as $key => $item){
                    $posts[$key]["link"] = null;
                } 
                return array(
                    "success" => false,
                    "message" => "User is unpaid",
                    "data" => $posts,
                );
            }

            return array(
                "success" => true,
                "message" => "Episodes available",
                "data" => $posts,
            );
        }

        return array(
            "success" => false,
            "message" => "No episode found"
        );
        
        
    }

}

?>