<?php

class Status{
    private $conn;
    private $table = "status";

    public function __construct($db){
        $this->conn = $db;
    }

    public function getStatus(){
        $query = "SELECT * FROM " . $this->table . " LIMIT 2";

        $status = $this->conn->prepare($query);
        $status->execute();

        $allStatuses = $status->fetchAll(PDO::FETCH_ASSOC);

        $posts = [];

        foreach($allStatuses as $allStatus){
            $posts [] = $allStatus;
        }

        if(count($posts) > 0){
            return array(
                "success" => true,
                "message" => "successful fetch",
                "data" => $posts
            );
        }

        return array(
            "success" => false,
            "message" => "No post found"
        );

        
    }
}

