<?php

class Utils{
    public $folder = "images/";

    public function getFileInfo($image){
        if(!empty($image)){
            $name = $image["name"];
            $size = $image["size"];
            $location = $image["tmp_name"];
            $extension = pathinfo($name, PATHINFO_EXTENSION);

            return array(
                "name" => $name,
                "size" => $size,
                "location" => $location,
                "extension" => $extension
            );
        }
        
    }

    public function checkFileFormat($image_extension){
        $extensions = array("jpg", "png", "webp", "jpeg", "gif");

        if(in_array($image_extension, $extensions)){
            return array(
                "success" => true,
                "message" => "Format is allowed",
            );
        }

        return array(
            "success" => false,
            "message" => "Choose only image",
        );
        
    }

    public function checksFileSize($file_size){
        $max_size = 1 * 1024 * 1024;
        if($file_size > $max_size){
            return array(
                "success" => false,
                "message" => "File size is too large",
            );
        }

        return array(
            "success" => true,
            "message" => "File is allowed",
        );
        
    }

    public function uploadFileToFolder($location, $name, $extension){
        $renamed_name = preg_replace("/[^A-Za-z0-9\-]/","", str_replace(" ", "-", strtolower($name)));
        $new_image_name = $renamed_name. "-". time(). ".". $extension;
    

        if(move_uploaded_file($location, $this->folder. $new_image_name)){
            return array(
                "success" => true,
                "message" => "File uploaded successful",
                "image_name" => $new_image_name,
            );
        }

        return array(
            "success" => false,
            "message" => "Upload failed",
        );

    }
}


?>