<?php

header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With, X-API-KEY");

include_once "config/Database.php";
include_once "models/User.php";
include_once "models/Apikey.php";

if($_SERVER["REQUEST_METHOD"] != "POST"){
    $response = array(
        "success" => false,
        "message" => "Unauthorized request"
    );
    echo json_encode($response);
    exit;
}

$database = new Database();
$db = $database->getConnection();

$auth = new Apikey($db);
$user = new User($db);

$headers = array_change_key_case(getallheaders(), CASE_LOWER);
$apikey = $headers['x-api-key'] ?? '';

if(!$apikey || !$auth->validateApikey($apikey)){
    $response = array(
        "success" => false,
        "message" => "Unauthorized: Invalid api key or empty key",
    );
    echo json_encode($response);
    exit;
}

$contentType = $_SERVER["CONTENT_TYPE"] ?? "";
if(strpos($contentType, "application/json") !== false){
    $data = json_decode(file_get_contents("php://input"));
    
    $_POST = $data ?? [];
} 


$device_id = $_POST["device_id"] ?? "";
$phone = $_POST["phone"] ?? "";
$status = $_POST["status"] ?? "";
$day = $_POST["day"] ?? "";
$date = $_POST["date"] ?? "";

if(empty($device_id) || empty($phone) || empty($status) || $day === "" || empty($date)){
    $response = array(
        "success" => false,
        "message" => "All fields are required"
    );

    echo json_encode($response);
    exit;
}

$user->device_id = $device_id;
$user->phone = $phone;
$user->status = $status;
$user->day = $day;
$user->date = $date;

$result = $user->signup();

if($result["success"]){
    echo json_encode($result);
    exit;
}

echo json_encode($result);



?>